function graph(sys,x,rho)
%   GRAPH permet de tracer graphiquement, sur un axe Ox, l'nergie
%   potentielle et la densit linique de probabilit de l'objet physique. 
%   GRAPH(sys,x,rho)
%       >> sys = Systme {nergie potentielle - objet physique}
%       >> x = valeur de la variable spatiale
%       >> rho = densit linique de probabilit
%       << Figure
%
%   Olivier Pujol : septembre 2013
%
%% Vrifications

if (nargin~=3);error('Mauvais nombre d''arguments d''entre !');end
if (isa(sys,'cell')==0),error('Le premier argument doit tre du type ''cellule'' !');end

%% Trac graphique

figure
subplot(2,1,1)
plotsys(sys,x);
subplot(2,1,2);
plot_rho(x,rho);
%
return;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function plotsys(sys,x)
%
if (nargin~=2),error('Mauvais nombre d''argument d''entre !');end
%
xmin=x{1}(1);
xmax=x{end}(end);

if ( xmin>sys{1}{1}(5) || xmax<sys{1}{1}(6) )
    error('Le systme est hors du domaine !');
end
%
%   On rcupre la position et la valeur des nergies potentielles pour la
%   premire valeur de l'nergie (sys{1}). C'est la mme chose pour les
%   autres valeurs de l'nergie

pos=nan(1,length(sys{1})-1);    % Initialisation
Ep=nan(1,length(sys{1})-1);     % Initialisation
%
for i=2:length(sys{1})
    if (isa(sys{1}{i},'marche')==0),error('Mauvais type d''argument !');end
    pos(i-1)=get(sys{1}{i},'Position');
    Ep(i-1)=get(sys{1}{i},'EnergiePotentielleSortie');
end
%
pos=[xmin pos xmax];
Ep_e=sys{1}{1}(1);
Ep_s=sys{1}{1}(2);
Ep=[Ep_e Ep Ep_s];
%
hs=stairs(pos,Ep);
set(hs,'LineWidth',2,'Color','b');
axis([xmin xmax min(Ep)-0.2*max(Ep) max(Ep)+0.2*max(Ep)]);
grid on;
box on
xlabel('{\itx} (nm)');
title('Energie potentielle (eV)');
%
return;
%
function plot_rho(x,rho)
%
if (nargin~=2),error('Mauvais nombre d''argument d''entre !');end
%
for i=1:length(x)
    plot(x{i},rho{i},'LineWidth',2,'Color','r');
    hold on;
end
axis tight;
grid on;
box on;
xlabel('{\itx} (nm)');
title('{\it{\rho_p}}');
%
return;
